package gov.va.med.mhv.usermgmt.web.controller;

import gov.va.med.mhv.common.api.exception.MHVException;

import javax.annotation.ManagedBean;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@ManagedBean
@Component
@Scope("session")
public class VlerHealthAuthController  extends AbstractController{
	
	private static final long serialVersionUID = 6889094990111312538L;
	private static Logger log = LogManager.getLogger(VlerHealthAuthController.class);
	
	public void init(ComponentSystemEvent event){
		
	}
	
	
	public String getVappiFormStatus(){
		String vapiiFormStatus=null;
		try {
			if(getUserProfileId() != null){
				vapiiFormStatus= accountValidatorService.getVapiiFormStatusForUser(getUserProfileId());
			}
		} catch (MHVException e) {
			log.error("VaapiFormStatuserror::",e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, "Error", "Error"));
		}
		return vapiiFormStatus;
	}

}
